/*============================================================================*/
/*                        DIAdem Connectivity Library                         */
/*----------------------------------------------------------------------------*/
/*    Copyright (c) National Instruments 2006.  All Rights Reserved.          */
/*----------------------------------------------------------------------------*/
/*                                                                            */
/* Title:       nilibddc.h                                                    */
/* Purpose:     Include file for DIAdem Connectivity Library                  */
/*                                                                            */
/*============================================================================*/

#ifndef _NILIBTDM_H
#define _NILIBTDM_H

//#include <stdarg.h>

#ifdef __cplusplus
extern "C" {
#endif

//*****************************************************************************
// Typedefs, enums, constants, etc.
//*****************************************************************************

#ifdef WIN32
	#pragma pack(push)
	#pragma pack(4)
#endif

#ifdef		_USE_VOIDPTR_
typedef void*					DDCFileHandle;
typedef void*					DDCChannelGroupHandle;
typedef void*					DDCChannelHandle;
#else		// !_USE_VOIDPTR_
typedef DWORD					DDCFileHandle;
typedef DWORD					DDCChannelGroupHandle;
typedef DWORD					DDCChannelHandle;
#endif		// !_USE_VOIDPTR_

#ifdef WIN32
	#pragma pack(pop)
#endif

typedef enum {
	DDC_UInt8		= 5,	// unsigned char
	DDC_Int16		= 2,	// short
	DDC_Int32		= 3,	// int
	DDC_Float		= 9,	// float
	DDC_Double		= 10,	// double
	DDC_String		= 23,	// string
} DDCDataType;

#define __int64 int
// File type constants
#define DDC_FILE_TYPE_TDM				"TDM"
#define DDC_FILE_TYPE_TDM_STREAMING		"TDMS"

// File property constants
#define DDC_FILE_NAME					"name"				// Name
#define DDC_FILE_DESCRIPTION			"description"		// Description
#define DDC_FILE_TITLE					"title"				// Title
#define DDC_FILE_AUTHOR					"author"			// Author

// ChannelGroup property constants
#define DDC_CHANNELGROUP_NAME			"name"				// Name
#define DDC_CHANNELGROUP_DESCRIPTION	"description"		// Description

// Channel property constants
#define DDC_CHANNEL_NAME				"name"				// Name
#define DDC_CHANNEL_DESCRIPTION			"description"		// Description
#define DDC_CHANNEL_UNIT_STRING			"unit_string"		// Unit String
#define DDC_CHANNEL_MINIMUM				"minimum"			// Minimum
#define DDC_CHANNEL_MAXIMUM				"maximum"			// Maximum

// Error codes
typedef enum {

	DDC_NoError									= 0,			// No error
	DDC_ErrorBegin								= -6201,		//

	DDC_OutOfMemory								= -6201,		// The library could not allocate memory.
	DDC_InvalidArgument							= -6202,		// An invalid argument was passed to the library.
	DDC_InvalidDataType							= -6203,		// An invalid data type was passed to the library.
	DDC_UnexpectedError							= -6204,		// An unexpected error occurred in the library.
	DDC_UsiCouldNotBeLoaded						= -6205,		// The USI engine could not be loaded.
	DDC_InvalidFileHandle						= -6206,		// An invalid file handle was passed to the library.
	DDC_InvalidChannelGroupHandle				= -6207,		// An invalid channel group handle was passed to the library.
	DDC_InvalidChannelHandle					= -6208,		// An invalid channel handle was passed to the library.
	DDC_FileDoesNotExist						= -6209,		// The file passed to the library does not exist.
	DDC_CannotWriteToReadOnlyFile				= -6210,		// The file passed to the library is read only and cannot be modified.
	DDC_StorageCouldNotBeOpened					= -6211,		// The storage could not be opened.
	DDC_FileAlreadyExists						= -6212,		// The file passed to the library already exists and cannot be created.
	DDC_PropertyDoesNotExist					= -6213,		// The property passed to the library does not exist.
	DDC_PropertyDoesNotContainData				= -6214,		// The property passed to the library does not have a value.
	DDC_PropertyIsNotAScalar					= -6215,		// The value of the property passed to the library is an array and not a scalar.
	DDC_DataObjectTypeNotFound					= -6216,		// The object type passed to the library does not exist.
	DDC_NotImplemented							= -6217,		// The current implementation does not support this operation.
	DDC_CouldNotSaveFile						= -6218,		// The file could not be saved.
	DDC_MaximumNumberOfDataValuesExceeded		= -6219,		// The request would exceed the maximum number of data values for a channel.
	DDC_InvalidChannelName						= -6220,		// An invalid channel name was passed to the library.
	DDC_DuplicateChannelName					= -6221,		// The channel group already contains a channel with this name.
	DDC_DataTypeNotSupported					= -6222,		// The current implementation does not support this data type.
	DDC_FileAccessDenied						= -6224,		// File access denied.

	DDC_ErrorEnd								= -6224,		//
	DDC_ErrorForceSizeTo32Bits					= 0xffffffff	//

} DDCError;

#pragma dll(nilibddc.dll, header)  
typedef char* va_list;    			//// AW 01/30/07 MORE_WORK_IN_EXPORT_TDM 

//*****************************************************************************
/// -> Object Management
//*****************************************************************************
int  __stdcall DDC_CreateFile (const char *filePath,				//// AW 01/30/07 MORE_WORK_IN_EXPORT_TDM
							  const char *fileType,
							  const char *name,
							  const char *description,
							  const char *title,
							  const char *author,
							  DDCFileHandle *ppfile);

int __stdcall DDC_AddChannelGroup (DDCFileHandle pfile,
								   const char *name,
								   const char *description,
								   DDCChannelGroupHandle *channelGroup);

int __stdcall DDC_AddChannel (DDCChannelGroupHandle channelGroup,
							  DDCDataType dataType,
							  const char *name,
							  const char *description,
							  const char *unitString,
							  DDCChannelHandle *channel);

int __stdcall DDC_SaveFile (DDCFileHandle pfile);

int __stdcall DDC_CloseFile (DDCFileHandle pfile);

int __stdcall DDC_OpenFileEx (const char *filePath,
							  const char *fileType,
							  int readOnly,
							  DDCFileHandle *pfile);

							  
int __stdcall DDC_OpenFile (const char *filePath,
							  const char *fileType,
							DDCFileHandle *ppfile);

//*****************************************************************************
/// -> Advanced
//*****************************************************************************
int __stdcall DDC_RemoveChannelGroup (DDCChannelGroupHandle channelGroup);

int __stdcall DDC_RemoveChannel (DDCChannelHandle channel);

int __stdcall DDC_CloseChannelGroup (DDCChannelGroupHandle channelGroup);

int __stdcall DDC_CloseChannel (DDCChannelHandle channel);

//*****************************************************************************
/// <- Advanced
//*****************************************************************************
//*****************************************************************************


//*****************************************************************************
/// <- Obsolete
//*****************************************************************************
//*****************************************************************************
/// <- Object Management
//*****************************************************************************

//*****************************************************************************
/// -> Data Storage
//*****************************************************************************
int __stdcall DDC_SetDataValues (DDCChannelHandle channel,
								 void *values,
								 unsigned int numValues);

int __stdcall DDC_AppendDataValues (DDCChannelHandle channel,
									void *values,
									unsigned int numValues);

int __stdcall DDC_ReplaceDataValues (DDCChannelHandle channel,
									 unsigned int indexOfFirstValueToReplace,
									 void *values,
									 unsigned int numValues);

//*****************************************************************************
/// <- Data Storage
//*****************************************************************************

//*****************************************************************************
/// -> Data Retrieval
//*****************************************************************************

//*****************************************************************************
/// -> Enumeration
//*****************************************************************************
int __stdcall DDC_GetNumChannelGroups (DDCFileHandle pfile,
									   unsigned int *numChannelGroups);

int __stdcall DDC_GetChannelGroups (DDCFileHandle pfile,
									DDCChannelGroupHandle channelGroupsBuf[],
									unsigned int numChannelGroups);

int __stdcall DDC_GetNumChannels (DDCChannelGroupHandle channelGroup,
								  unsigned int *numChannels);

int __stdcall DDC_GetChannels (DDCChannelGroupHandle channelGroup,
							   DDCChannelHandle channelsBuf[],
							   unsigned int numChannels);

//*****************************************************************************
/// <- Enumeration
//*****************************************************************************

int __stdcall DDC_GetNumDataValues (DDCChannelHandle channel,
									unsigned __int64 *numValues);

int __stdcall DDC_GetDataValues (DDCChannelHandle channel,
								 unsigned int indexOfFirstValueToGet,
								 unsigned int numValuesToGet,
								 void *values);

int __stdcall DDC_GetDataType (DDCChannelHandle channel,
							   DDCDataType *dataType);

//*****************************************************************************
/// <- Data Retrieval
//*****************************************************************************

//*****************************************************************************
/// -> Properties
//*****************************************************************************

//*****************************************************************************
/// -> File
//*****************************************************************************
int __cdecl DDC_SetFileProperty (DDCFileHandle pfile,
								 const char *property,
								 ...);

int __stdcall DDC_SetFilePropertyV (DDCFileHandle pfile,
									const char *property,
									va_list args);

int __stdcall DDC_GetFileProperty (DDCFileHandle pfile,
								   const char *property,
								   void *value,
								   unsigned int valueSizeInBytes);

int __stdcall DDC_GetFileStringPropertyLength (DDCFileHandle pfile,
											   const char *property,
											   unsigned int *length);

int __cdecl DDC_CreateFileProperty (DDCFileHandle pfile,
									const char *property,
									DDCDataType dataType,
									...);

int __stdcall DDC_CreateFilePropertyV (DDCFileHandle pfile,
									   const char *property,
									   DDCDataType dataType,
									   va_list args);

int __stdcall DDC_FilePropertyExists (DDCFileHandle pfile,
									  const char *property,
									  int *exists);

int __stdcall DDC_GetNumFileProperties (DDCFileHandle pfile, 
										unsigned int *numProperties);

int __stdcall DDC_GetFilePropertyNames (DDCFileHandle pfile, 
										char** propertyNames, 
										unsigned int numPropertyNames);

int __stdcall DDC_GetFilePropertyType (DDCFileHandle pfile, 
									   const char *property, 
									   DDCDataType *dataType);

//*****************************************************************************
/// <- File
//*****************************************************************************

//*****************************************************************************
/// -> Channel Group
//*****************************************************************************
int __cdecl DDC_SetChannelGroupProperty (DDCChannelGroupHandle channelGroup,
										 const char *property,
										 ...);

int __stdcall DDC_SetChannelGroupPropertyV (DDCChannelGroupHandle channelGroup,
											const char *property,
											va_list args);

int __stdcall DDC_GetChannelGroupProperty (DDCChannelGroupHandle channelGroup,
										   const char *property,
										   void *value,
										   unsigned int valueSizeInBytes);

int __stdcall DDC_GetChannelGroupStringPropertyLength (DDCChannelGroupHandle channelGroup,
													   const char *property,
													   unsigned int *length);

int __cdecl DDC_CreateChannelGroupProperty (DDCChannelGroupHandle channelGroup,
											const char *property,
											DDCDataType dataType,
											...);

int __stdcall DDC_CreateChannelGroupPropertyV (DDCChannelGroupHandle channelGroup,
											   const char *property,
											   DDCDataType dataType,
											   va_list args);

int __stdcall DDC_ChannelGroupPropertyExists (DDCChannelGroupHandle channelGroup,
											  const char *property,
											  int *exists);

int __stdcall DDC_GetNumChannelGroupProperties (DDCChannelGroupHandle channelGroup, 
												unsigned int *numProperties);

int __stdcall DDC_GetChannelGroupPropertyNames (DDCChannelGroupHandle channelGroup, 
												char** propertyNames, 
												unsigned int numPropertyNames);

int __stdcall DDC_GetChannelGroupPropertyType (DDCChannelGroupHandle channelGroup, 
											   const char *property, 
											   DDCDataType *dataType);

//*****************************************************************************
/// <- Channel Group
//*****************************************************************************

//*****************************************************************************
/// -> Channel
//*****************************************************************************
int __cdecl DDC_SetChannelProperty (DDCChannelHandle channel,
									const char *property,
									...);

int __stdcall DDC_SetChannelPropertyV (DDCChannelHandle channel,
									   const char *property,
									   va_list args);

int __stdcall DDC_GetChannelProperty (DDCChannelHandle channel,
									  const char *property,
									  void *value,
									  unsigned int valueSizeInBytes);

int __stdcall DDC_GetChannelStringPropertyLength (DDCChannelHandle channel,
												  const char *property,
												  unsigned int *length);

int __cdecl DDC_CreateChannelProperty (DDCChannelHandle channel,
									   const char *property,
									   DDCDataType dataType,
									   ...);

int __stdcall DDC_CreateChannelPropertyV (DDCChannelHandle channel,
										  const char *property,
										  DDCDataType dataType,
										  va_list args);

int __stdcall DDC_ChannelPropertyExists (DDCChannelHandle channel,
										 const char *property,
										 int *exists);

int __stdcall DDC_GetNumChannelProperties (DDCChannelHandle channel, 
										   unsigned int *numProperties);

int __stdcall DDC_GetChannelPropertyNames (DDCChannelHandle channel, 
										   char** propertyNames, 
										   unsigned int numPropertyNames);

int __stdcall DDC_GetChannelPropertyType (DDCChannelHandle channel, 
										  const char *property, 
										  DDCDataType *dataType);

//*****************************************************************************
/// <- Channel
//*****************************************************************************

//*****************************************************************************
/// <- Properties
//*****************************************************************************

//*****************************************************************************
/// -> Miscellaneous
//*****************************************************************************
const char * __stdcall DDC_GetLibraryErrorDescription (int errorCode);

void __stdcall DDC_FreeMemory (void *memoryPointer);

//*****************************************************************************
/// <- Miscellaneous
//*****************************************************************************

#ifdef __cplusplus
	}
#endif

#endif //!defined(_NILIBTDM_H)
